package com.qboxus.tictic.repositories

import androidx.lifecycle.MutableLiveData
import com.google.gson.Gson
import com.qboxus.tictic.Constants
import com.qboxus.tictic.activitesfragments.shoping.models.ProductModel
import com.qboxus.tictic.apiclasses.ApiResponce
import com.qboxus.tictic.models.PrivacySettingModel
import com.qboxus.tictic.models.PushNotificationModel
import com.qboxus.tictic.models.SoundsModel
import com.qboxus.tictic.models.StoryModel
import com.qboxus.tictic.models.UserModel
import com.qboxus.tictic.simpleclasses.DataParsing
import com.qboxus.tictic.simpleclasses.DataParsing.getVideoDataModel
import com.qboxus.tictic.simpleclasses.Functions
import org.json.JSONArray
import org.json.JSONObject

class ShopRepository : BaseRepository<UserModel>() {


    suspend fun getShopsList(
        params: JSONObject,
        liveData: MutableLiveData<ApiResponce<ArrayList<UserModel>>>,
    ) {

        try {


        val endpoint = { requestBody: String ->
            apiInterface.showShops(requestBody)
        }
        val parseData = { apiResponseData: ApiResponseData ->
            when (apiResponseData) {
                is ApiResponseData.JsonArray -> {
                    val list = ArrayList<UserModel>()
                    for (i in 0 until apiResponseData.data.length()) {
                        val `object` = apiResponseData.data.optJSONObject(i)
                        val userDetailModel =
                            DataParsing.getUserDataModel(`object`.optJSONObject("User"))

                        list.add(userDetailModel)
                    }
                    list
                }

                else -> throw IllegalArgumentException("Unsupported response type")
            }
        }

        makeApiCall(params, endpoint, liveData, parseData)

        }catch (e:Exception){}
    }

}